﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1250" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Place" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">

	//Wydruk ma być drukowany wg daty wypłaty (true),
	//czy wg okresu za który zostały one zrealizowane (false)
	static readonly bool wgDatyWypłaty = false;

	//Wydruk drukowany z rozbiciem wynagrodzeń na poszczególne wydziały
	static readonly bool wgWydziałów = true;
	
	[Flags]
	public enum Przychody {
		Pracownika					= 0x01,
		Zleceniobiorcy				= 0x02,
		Razem						= 0x99,
	}

	public class PrnParams: ContextBase {
	
		public PrnParams(Context context): base(context) {
			Date data = ((ActualDate)context[typeof(ActualDate)]).Actual;
			okres = FromTo.Year(data.Year);
		}

		FromTo okres;
		[Required]
		[Priority(1)]
		public FromTo Okres {
			get { return okres; }
			set {
				okres = value;
				OnChanged(EventArgs.Empty);
			}
		}

		Przychody przychody = Przychody.Pracownika;
		[Priority(3)]
		public Przychody Przychody {
			get { return przychody; }
			set { 
				przychody = value; 
				OnChanged(EventArgs.Empty);
			}
		}
	}
    
	PrnParams pars;
	[Context]
	public PrnParams Params {
		set { pars = value; }
	}
		
    class Comparer: IComparer {
		public int Compare(object a, object b) {
			DefinicjaElementu da = (DefinicjaElementu)a;
			DefinicjaElementu db = (DefinicjaElementu)b;
			return da.Nazwa.CompareTo(db.Nazwa);
		}
    }
        
    string GetKey(WypElement element) {
		if (!wgWydziałów)
			return "";
		Wydzial w = element.Wydzial;
		return w==null ? "" : w.Kod;
    }
    
    SubTable ElementyZaOkres(Pracownik pracownik, FromTo okres) {
		PlaceModule płace = PlaceModule.GetInstance(pracownik);
		SubTable st = wgDatyWypłaty ? płace.WypElementy.WgDaty[pracownik] : płace.WypElementy.WgPracownik[pracownik];
		return new SubTable(st, okres);
    }
    
	void OnContextLoad(Object sender, EventArgs args) {
		Row[] rows = (Row[])dc[typeof(Row[])];

		PlaceModule płace = PlaceModule.GetInstance(dc);
		Hashtable ht = new Hashtable();

        foreach (Pracownik pracownik in rows) {
			SubTable elementy = ElementyZaOkres(pracownik, pars.Okres);
			foreach (WypElement element in elementy) {
                try {
				    if (Pasuje(element, pars.Przychody))
					    if (ht[element.Definicja]==null)
						    ht.Add(element.Definicja, 0m);
                }
                catch { }
            }
		}
						
		ArrayList definicje = new ArrayList(ht.Keys);
		definicje.Sort(new Comparer());
		
		Write("Lp.");
		Write("Kod");
		Write("Pracownik");
		if (wgWydziałów)
			Write("Wydział");
		
		Write("Brutto");
		Write("Składki pracownika");
		Write("Koszty uzyskania");
		Write("Podstawa opodatkowania");
		Write("Ulga podatkowa");
		Write("Składka zdrowotna");
		Write("Składka zdrowotna do doliczenia");
		Write("");
		Write("Zaniechanie poboru zaliczki");
		Write("Zaliczka podatku");		
		
		Write("Emerytalna/U");
		Write("Emerytalna/P");
		Write("Rentowa/U");
		Write("Rentowa/P");
		Write("Chorobowa");
		Write("Wypadkowa");
		Write("Zdrowotna");
		Write("FP");
		Write("FGŚP");
        Write("FEP");
		
		foreach (DefinicjaElementu definicja in definicje)
			Write(definicja.Nazwa);
			
		Wyplata.PITInfoWorker pit = new Wyplata.PITInfoWorker();
		WyplataSkładkiWorker zus = new WyplataSkładkiWorker();
		
		int c = 0;
        foreach (Pracownik pracownik in rows) {
			SubTable st = ElementyZaOkres(pracownik, pars.Okres);
			Hashtable wgw = new Hashtable();
			foreach (WypElement element in st) {
                try {
				    if (Pasuje(element, pars.Przychody)) {
					    object key = GetKey(element);
					    ArrayList elementy = (ArrayList)wgw[key];
					    if (elementy==null)
						    wgw.Add(key, elementy = new ArrayList());
					    elementy.Add(element);
				    }
                }
                catch { }
            }

			foreach (DictionaryEntry de in wgw) {		
				ArrayList elementy = (ArrayList)de.Value;
				WriteLn();
				Write(++c);
				Write(pracownik.Kod);
				Write(pracownik.NazwiskoImię);	
				if (wgWydziałów)
					Write(de.Key);

				pit.Elementy = elementy;
				Write(pit.Brutto);
				Write(pit.SkładkiZUS);
				Write(pit.KosztyFIS);
				Write(pit.Podstawa);
				Write(pit.Ulga);
				Write(pit.SkładkaZdrow);
				Write(pit.ZdrowotneDoOdliczenia);
				Write(""/*pit.ZdrowotneFaktycznieOdliczon e*/);
				Write(pit.ZanFIS);
				Write(pit.ZalFIS);		

				zus.Elementy = elementy;
				Write(zus.Razem.Emerytalna.Prac);
				Write(zus.Razem.Emerytalna.Firma);
				Write(zus.Razem.Rentowa.Prac);
				Write(zus.Razem.Rentowa.Firma);
				Write(zus.Razem.Chorobowa.Prac + zus.Razem.Chorobowa.Firma);
				Write(zus.Razem.Wypadkowa.Prac + zus.Razem.Wypadkowa.Firma);
				Write(zus.Razem.Zdrowotna.Prac + zus.Razem.Zdrowotna.Firma);
				Write(zus.Razem.FP.Firma);
				Write(zus.Razem.FGSP.Firma);
                Write(zus.Razem.FEP.Firma);
					
				ht = new Hashtable();
				foreach (WypElement element in elementy) {
					object v = ht[element.Definicja];
					if (v==null)
						ht.Add(element.Definicja, element.Wartosc);
					else
						ht[element.Definicja] = element.Wartosc + (decimal)v;
				}
				
				foreach (DefinicjaElementu def in definicje) {
					object v = ht[def];
					if (v==null)
						Write("");
					else
						Write((decimal)v);
				}
			}
		}
	}
	
	bool Pasuje(WypElement element, Przychody przychody) {
		switch (przychody) {
			case Przychody.Pracownika:
				return element.Wyplata.Typ!=TypWyplaty.Umowa;
			case Przychody.Zleceniobiorcy:
				return element.Wyplata.Typ==TypWyplaty.Umowa;
		}
		return true;
	}
	
	void WriteLn() {
		_Write("\r\n");
	}
	
	void Write(decimal d) {
		if (d==0m)
			Write("");
		else
			Write(d.ToString());
	}
	
	void Write() {
		Write("");
	}
	
	void Write(object obj) {
		_Write((obj==null ? "" : obj.ToString()) + ";");
	}
	
	void _Write(string s) {
		Response.Write(s);
	}

	//Pomocne w trakcie szukania błądów
	static void Msg(object obj) {
	}

</script>
<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.Business.Row[],Soneta.Business" />
